<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class statscarrier extends ModuleGraph
{
    private $html = '';
    private $option = '';

    public function __construct()
    {
        $this->name = 'statscarrier';
        $this->tab = 'administration';
        $this->version = '2.1.0';
        $this->author = 'PrestaShop';
        $this->need_instance = 0;

        parent::__construct();

        $this->displayName = $this->trans('Carrier distribution', array(), 'Modules.Statscarrier.Admin');
        $this->description = $this->trans('Enrich your stats, add a pie chart illustrating your carriers’ distribution.', array(), 'Modules.Statscarrier.Admin');
        $this->ps_versions_compliancy = array('min' => '1.7.1.0', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        return (parent::install() && $this->registerHook('displayAdminStatsModules'));
    }

    public function hookDisplayAdminStatsModules($params)
    {
        $sql = 'SELECT COUNT(o.`id_order`) as total
				FROM `'._DB_PREFIX_.'orders` o
				WHERE o.`date_add` BETWEEN '.ModuleGraph::getDateBetween().'
					'.Shop::addSqlRestriction(Shop::SHARE_ORDER, 'o').'
					'.((int)Tools::getValue('id_order_state') ? 'AND (SELECT oh.id_order_state FROM `'._DB_PREFIX_.'order_history` oh WHERE o.id_order = oh.id_order ORDER BY oh.date_add DESC, oh.id_order_history DESC LIMIT 1) = '.(int)Tools::getValue('id_order_state') : '');
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($sql);
        $states = OrderState::getOrderStates($this->context->language->id);

        if (Tools::getValue('export')) {
            $this->csvExport(array('type' => 'pie', 'option' => Tools::getValue('id_order_state')));
        }
        $this->html = '
			<div class="panel-heading">
				'.$this->displayName.'
			</div>
			<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" class="form-horizontal alert">
				<div class="row">
					<div class="col-lg-5 col-lg-offset-6">
						<select name="id_order_state">
							<option value="0"'.((!Tools::getValue('id_order_state')) ? ' selected="selected"' : '').'>'.$this->trans('All', array(), 'Admin.Global').'</option>';
        foreach ($states as $state) {
            $this->html .= '<option value="'.$state['id_order_state'].'"'.(($state['id_order_state'] == Tools::getValue('id_order_state')) ? ' selected="selected"' : '').'>'.$state['name'].'</option>';
        }
        $this->html .= '</select>
					</div>
					<div class="col-lg-1">
						<input type="submit" name="submitState" value="'.$this->trans('Filter', array(), 'Admin.Global').'" class="btn btn-default pull-right" />
					</div>
				</div>
			</form>

			<div class="alert alert-info">
				'.$this->trans('This graph represents the carrier distribution for your orders. You can also narrow the focus of the graph to display distribution for a particular order status.', array(), 'Modules.Statscarrier.Admin').'
			</div>
			<div class="row row-margin-bottom">
				<div class="col-lg-12">
					<div class="col-lg-8">
						'.($result['total'] ? $this->engine(array(
                    'type' => 'pie',
                    'option' => Tools::getValue('id_order_state')
                )).'
					</div>
					<div class="col-lg-4">
						<a href="'.Tools::safeOutput($_SERVER['REQUEST_URI'].'&export=1&exportType=language').'" class="btn btn-default">
							<i class="icon-cloud-upload"></i> '.$this->trans('CSV Export', array(), 'Admin.Global').'
						</a>' : $this->trans('No valid orders have been received for this period.', array(), 'Modules.Statscarrier.Admin')).'
					</div>
				</div>
			</div>';

        return $this->html;
    }

    public function setOption($option, $layers = 1)
    {
        $this->option = (int)$option;
    }

    protected function getData($layers)
    {
        $state_query = '';
        if ((int)$this->option) {
            $state_query = 'AND (
				SELECT oh.id_order_state FROM `'._DB_PREFIX_.'order_history` oh
				WHERE o.id_order = oh.id_order
				ORDER BY oh.date_add DESC, oh.id_order_history DESC
				LIMIT 1) = '.(int)$this->option;
        }
        $this->_titles['main'] = $this->trans('Percentage of orders listed by carrier.', array(), 'Modules.Statscarrier.Admin');

        $sql = 'SELECT c.name, COUNT(DISTINCT o.`id_order`) as total
				FROM `'._DB_PREFIX_.'carrier` c
				LEFT JOIN `'._DB_PREFIX_.'orders` o ON o.id_carrier = c.id_carrier
				WHERE o.`date_add` BETWEEN '.ModuleGraph::getDateBetween().'
					'.Shop::addSqlRestriction(Shop::SHARE_ORDER, 'o').'
					'.$state_query.'
				GROUP BY c.`id_reference`';
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
        foreach ($result as $row) {
            $this->_values[] = $row['total'];
            $this->_legend[] = $row['name'];
        }
    }
}
